function replaceTextContent(element, replacements) {
    // אם לאלמנט יש ילדים, נבצע את הפונקציה רקורסיבית על כל הילדים
    if (element.hasChildNodes()) {
        element.childNodes.forEach(function(child) {
            replaceTextContent(child, replacements);
        });
    } else if (element.nodeType === Node.TEXT_NODE) {
        // אם זהו אלמנט טקסט, נבצע את ההחלפות
        let textContent = element.textContent;
        replacements.forEach(function(replacement) {
            textContent = textContent.replace(new RegExp(replacement.search, 'g'), replacement.replace);
        });
        element.textContent = textContent;
    }
}

// פונקציה שמחפשת ומחליפה את המילים בהתאם לרשימת ההחלפות
function replaceTextInDocument() {
    // רשימת ההחלפות
    var replacements = [
        //תפריט עליון
        { search: 'Find a view', replace: 'חפש סגנון' },
        { search: 'Interfaces', replace: 'ממשקים' },
        { search: 'Data', replace: 'נתונים' },
        { search: 'Automations', replace: 'אוטומציות' },
        { search: 'Views', replace: 'עיצובים' },
        { search: 'Help', replace: 'עזרה' },
        { search: 'Share', replace: 'שתף' },
        //תפריט צד שמאול
        { search: 'Table ', replace: 'גליון ' },
        { search: 'Tools', replace: 'כלים ' },
        { search: 'Extensions', replace: 'הרחבות ' },
        { search: 'Views', replace: ' עיצובים' },
        { search: 'view', replace: ' עיצוב' },
        { search: 'Grid', replace: 'טבלה' },
        { search: 'Grid ', replace: 'טבלה' },
        { search: 'Calendar', replace: 'לוח שנה' },
        { search: 'Calendar ', replace: 'לוח שנה' },
        { search: 'Gallery', replace: ' גלריה' },
        { search: 'Gallery ', replace: ' גלריה' },
        { search: 'Kanban', replace: 'קנבן' },
        { search: 'Kanban ', replace: 'קנבן' },
        { search: 'Team', replace: 'קבוצה' },
        { search: 'Form ', replace: ' טופס' },
        { search: 'Timeline', replace: 'ציר זמן' },
        { search: 'Timeline ', replace: 'ציר זמן' },
        { search: 'Form', replace: ' טופס' },
        { search: 'Save', replace: 'שמור' },
        { search: 'Save ', replace: ' שמור' }
    ];
    
    // קבלת כל האלמנטים בדף
    var allElements = document.getElementsByTagName("*");
    for (var i = 0; i < allElements.length; i++) {
        replaceTextContent(allElements[i], replacements);
    }
}

// הפעלת הפונקציה כאשר הדף נטען
replaceTextInDocument();




  